#include <cv.h>
#include <cxcore.h>
#include <highgui.h>
#include <math.h>
#include <iostream>
#include <fstream>

#include <XnOS.h>
#include <XnCppWrapper.h>
#include "cam.h"

using namespace std;
using namespace cv;
using namespace xn;

//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------
#define SAMPLE_XML_PATH "SamplesConfig.xml"

//---------------------------------------------------------------------------
// Globals
//---------------------------------------------------------------------------
Context g_context;
DepthGenerator g_depth;
ImageGenerator g_image;
DepthMetaData g_depthMD;
ImageMetaData g_imageMD;

IplImage *GlViewColor(IplImage *depth, IplImage *depthL, IplImage *depthU)
{
	static IplImage *image = 0;
	if (!image) image = cvCreateImage(cvSize(640,480), 8, 1);
	unsigned char *depth_mid = (unsigned char *)(image->imageData);
	unsigned char *depth_L = (unsigned char *)(depthL->imageData);
	unsigned char *depth_U = (unsigned char *)(depthU->imageData);
	int i;
	for (i = 0; i < 640*480; i++) {
		int lb = ((short *)depth->imageData)[i] % 256;
		int ub = ((short *)depth->imageData)[i] / 256;

		//depth_mid[3*i+2] = ub;
		//depth_mid[3*i+1] = ub;
		depth_mid[i+0] = lb;
		depth_L[i] = lb;
		depth_U[i] = ub+50;
	}
	return image;
}

//retrieve new frame
int capture(IplImage *img, IplImage *depth) {
	// Read a new frame
	XnStatus rc = XN_STATUS_OK;
	rc = g_context.WaitAnyUpdateAll();
	if (rc != XN_STATUS_OK)
	{
		printf("Read failed: %s\n", xnGetStatusString(rc));
		return 0;
	}

	g_depth.GetMetaData(g_depthMD);
	g_image.GetMetaData(g_imageMD);

	const XnDepthPixel* pDepth = g_depthMD.Data();
	const XnUInt8* pImage = g_imageMD.Data();

	//store images
	char *data = 0;
	memcpy(img->imageData, pImage, 640*480*3*sizeof(char));
	cvCvtColor(img, img, CV_BGR2RGB);

	data = 0;
	memcpy(depth->imageData, pDepth, 640*480*2*sizeof(char));

	cvFlip(depth, depth, 1);
	cvFlip(img, img, 1);

	return 1;
}

int main(int argc, char* argv[])
{
	XnStatus rc;

	//windows
	cvNamedWindow("win1", 1);
	cvNamedWindow("win2", 1);
	cvNamedWindow("win3", 1);

	//images
	IplImage *image = cvCreateImage(cvSize(640, 480), 8, 3);
	IplImage *depth = cvCreateImage(cvSize(640, 480), 16, 1);

	//file save
	ofstream saveL, saveU;
	CvMat stub, *saveMat;

	///////////////////////////////////////////
	saveL.open ("saveL.bin", ios::out | ios::binary);
	saveU.open ("saveU.bin", ios::out | ios::binary);

	//save header
	if (saveL.is_open()) 
	{
		//no header this time
	}

	EnumerationErrors errors;
	rc = g_context.InitFromXmlFile(SAMPLE_XML_PATH, &errors);
	if (rc == XN_STATUS_NO_NODE_PRESENT)
	{
		XnChar strError[1024];
		errors.ToString(strError, 1024);
		printf("%s\n", strError);
		return (rc);
	}
	else if (rc != XN_STATUS_OK)
	{
		printf("Open failed: %s\n", xnGetStatusString(rc));
		return (rc);
	}

	rc = g_context.FindExistingNode(XN_NODE_TYPE_DEPTH, g_depth);
	rc = g_context.FindExistingNode(XN_NODE_TYPE_IMAGE, g_image);


	int cycle = 1;
	int saving = 1;
	int init  = 0;

	IplImage *depth3, *depthL, *depthU;

	depthL = cvCreateImage(cvSize(640,480), 8, 1);
	depthU = cvCreateImage(cvSize(640,480), 8, 1);

	//while(cycle) {

		//printf("%d\n", depth->imageSize);

		//get new frame
		if(capture(image, depth) == 0)
			return 0;

		depth3 = GlViewColor(depth, depthL, depthU);

		cvShowImage("win1", depthL);
		cvShowImage("win2", depthU);
		char c = cvWaitKey(0);

		//save data to file
		if(saving == 1 && saveL.is_open()) 
		{
			//convert to Mat
			//saveMat = cvGetMat( depth, &stub, 0, 0);
			//save
			/*for(int a = 0; a < depth->width*depth->height; a+=1) {
				short ass = *(depth->imageData+a);
				saveL.write((char*)&ass, sizeof(ass));
			}*/

			//saveL.write((char*)(depthL->imageData), depthL->imageSize);
			//saveU.write((char*)(depthU->imageData), depthU->imageSize);
			
			for(int a = 0; a < depth->width*depth->height*2; a++) {
				depth->imageData[a] += 50;
			}
			
			saveL.write((char*)(depth->imageData), depth->imageSize);
			
		}

		if(c == 'a') {
			saving = 1;
		} else if (c == 'x') {
			cycle = 0;
		}

	//}

	saveL.flush();
	saveL.close();
	saveU.flush();
	saveU.close();

	//tst
	IplImage *depth2 = cvCreateImage(cvSize(640, 480), 16, 1);
	IplImage *depth4 = cvCreateImage(cvSize(640, 480), 8, 1);
	ifstream loadL, loadU;
	loadL.open("saveL.bin");
	loadU.open("saveU.bin");

	loadL.seekg(0, ios::beg);
	loadU.seekg(0, ios::beg);
	//for(int a = 0; a < depth->width*depth->height; a+=1)
	//	loadfile.read((char*)(depth2->imageData+a*2), 2);
	loadL.read((char*)depth2->imageData, depth2->imageSize);
	loadU.read((char*)depth4->imageData, depth3->imageSize);

	cvShowImage("win1", depth);
	cvShowImage("win2", depth2);
	cvShowImage("win3", depth4);

	cvWaitKey(0);

	loadL.close();
	loadU.close();

	return 0;
}